﻿//Copyright (C) 2010  Jonathan Preece
//
//This program is free software: you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation, either version 3 of the License, or
//(at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program.  If not, see <http://www.gnu.org/licenses/>.

using System;
using System.Drawing;

namespace RevisionAnalyser.Global.EasterEgg
{
    /// <summary>
    /// Represents a part of the snakes body
    /// </summary>
    public class Segment : ICloneable
    {
        private Rectangle _rectangle;

        #region Constructor

        public Segment(int width, int height)
        {
            _rectangle = new Rectangle(0, 0, width, height);
        }

        public Segment(int width, int height, int x, int y)
        {
            _rectangle = new Rectangle(x, y, width, height);
        }

        #endregion

        #region Public Properties

        public int X
        {
            get { return _rectangle.X; }
            set { _rectangle.X = value; }
        }

        public int Y
        {
            get { return _rectangle.Y; }
            set { _rectangle.Y = value; }
        }

        #endregion

        #region Public Static Methods

        /// <summary>
        /// Checks equality between two segments
        /// </summary>
        /// <param name="a">Segment a</param>
        /// <param name="b">Segment b</param>
        /// <returns>True if the segments are position the same, otherwise, false</returns>
        public static bool Equals(Segment a, Segment b)
        {
            return a.X == b.X && a.Y == b.Y;
        }

        #endregion

        #region Public Methods

        public Rectangle ToRectangle()
        {
            return _rectangle;
        }

        #endregion

        #region Implementation of ICloneable

        public object Clone()
        {
            return MemberwiseClone();
        }

        #endregion
    }
}